/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.yabn.elements.primitives;

import com.teamresourceful.yabn.elements.YabnType;
import com.teamresourceful.yabn.elements.primitives.PrimitiveContents;
import com.teamresourceful.yabn.utils.ByteArrayUtils;
import com.teamresourceful.yabn.utils.ByteUtils;
import java.nio.charset.StandardCharsets;

public record StringContents(String value, int nulls) implements PrimitiveContents
{
    public StringContents(String value) {
        this(value, StringContents.getNulls(value));
    }

    @Override
    public YabnType getId() {
        return this.value.isEmpty() ? YabnType.EMPTY_STRING : (this.nulls != 0 ? YabnType.NULL_STRING : YabnType.STRING);
    }

    @Override
    public byte[] toData() {
        if (this.value.isEmpty()) {
            return new byte[0];
        }
        if (this.nulls != 0) {
            return ByteArrayUtils.add(ByteUtils.vIntToBytes(this.nulls), ByteArrayUtils.add(this.value.getBytes(StandardCharsets.UTF_8), 0));
        }
        return ByteArrayUtils.add(this.value.getBytes(StandardCharsets.UTF_8), 0);
    }

    private static int getNulls(String value) {
        int nulls = 0;
        for (char c : value.toCharArray()) {
            if (c != '\u0000') continue;
            ++nulls;
        }
        return nulls;
    }
}

